//------------------------------------------------------------------------------
// File: cmn_inventory.cs
// This file contains the common methods for the player inventory
// Author: Matthew Rudge
//------------------------------------------------------------------------------

$INV_INVALID   = 0;
$INV_DYNAMITE  = 1;
$INV_HEALING   = 2;
$INV_TOMBSTONE = 3;
$INV_PLANTING  = 4;
$INV_SLOTCOUNT = 4;

////////////////////////////////////////////////////////////////////////////////
//! Creates a connection's inventory object
//! \param %conn Connection
//! \param %slot Number of slots for inventory
////////////////////////////////////////////////////////////////////////////////
function invCreateInventory(%conn, %slots)
{
   if(invExists(%conn)) {
      return;
   }
   
   invCreate(%conn);
   invSetSlotCount(%conn, %slots);
}

////////////////////////////////////////////////////////////////////////////////
//! Destroy's a connection's inventory object
//! \param %conn Connection
////////////////////////////////////////////////////////////////////////////////
function invDestroyInventory(%conn)
{
   invDestroy(%conn);
}

////////////////////////////////////////////////////////////////////////////////
//! Tests if the inventory slot has the item specified
//! \param %conn Connection with inventory
//! \param %slot Slot number
//! \param %item Item id
//! \retval bool True if the slot has the item
////////////////////////////////////////////////////////////////////////////////
function invSlotHasItem(%conn, %slot, %item)
{
   return (invGetItem(%conn, %slot) == %item);
}

////////////////////////////////////////////////////////////////////////////////
//! Tests if there is another item to pop from the stack at the specified slot
//! \param %conn Connection with inventory
//! \param %slot Slot for item
//! \retval bool True if an item can be popped from the stack
////////////////////////////////////////////////////////////////////////////////
function invCanPopItem(%conn, %slot)
{
   return (invGetItemStackCount(%conn, %slot) > 0);
}

////////////////////////////////////////////////////////////////////////////////
//! Checks if another item can be added to the stack at the specified slot
//! \param %client Client with inventory
//! \param %slot Slot for item
//! \retval bool True if an item can be added to the stack
////////////////////////////////////////////////////////////////////////////////
function invCanPushItem(%client, %slot)
{
   return (invGetItemStackCount(%client, %slot) < invGetItemStackMax(%client, %slot));
}

////////////////////////////////////////////////////////////////////////////////
//! Retrieves the slot number for an item
//! \param %conn Connection with item
//! \param %item Item to search for
//! \retval int Slot number or -1
////////////////////////////////////////////////////////////////////////////////
function invGetSlotForItem(%conn, %item)
{
   %slotCnt = invGetSlotCount(%conn);
   for(%slot = 0; %slot < %slotCnt; %slot++) {
      if(invSlotHasItem(%conn, %slot, %item)) {
         return %slot;
      }
   }
   return -1;
}
   
// End cmn_inventory.cs